N = 36;
% N = 128;
ksp = (0:N - 1) - floor(N/2);
f = 0.020;

% create signal.
% =========================
S = exp(1i*2*pi*f*ksp).';

% shift by shift_pixels pixels from -0.5 to approximately 0.5.
% ===============================================================
num_pixels = 300;
shift_pixels = (-num_pixels/2:num_pixels/2 - 1)/num_pixels;
ks = S.*exp(-2*pi*1i/N*ksp(:)*shift_pixels);       % shifted ks.

% Fourier transform and find the sparsest FT from all pixel shifts.
% ========================================================================
fs = ifftc(ks);
F = sum(abs(fs));
[~, J] = min(F);       % shift J has the most sparse result.

% plot
% =========
figure; plot(1:N, real(ks(:, 1)), 'b-*', 1:N, imag(ks(:, 1)), 'm-*'); grid;
legend(' real ', ' imag ');
title(' Original signal with an arbitrary number of cycles. ')

figure; plot(1:N, real(fs(:, 1)), 1:N, imag(fs(:, 1)), 'm'); grid;
legend(' real ', ' imag ');
title(' FT without pixel shift: strong Gibbs atifact. ')

figure; plot(1:N, real(ks(:, J)), 'b-*', 1:N, imag(ks(:, J)), 'm-*'); grid;
legend(' real ', ' imag ');
title([' Signal with shift of ', num2str(shift_pixels(J)), ' pixels. An integer number of cycles.'])

figure; plot(1:N, real(fs(:, J)), 1:N, imag(fs(:, J)), 'm'); grid;
legend(' real ', ' imag ');
title(' FT of pixel-shifted signal: No Gibbs artifact. ')


N = 1280;
ksp = (0:N - 1) - floor(N/2);
f1 = -0.37;
f2 = -0.39;
% f1 = 15.5/ksp(end);
% f2 = -10.5/ksp(end);
S = exp(1i*2*pi*f1*ksp) + exp(1i*2*pi*f2*ksp);
S = S(:);
kernel = 2;
neighbors = 1;
% [f_out, fn] = ring_remove(S, kernel, neighbors);
[f_out, fn] = ring_remove(S, 1, 15);
plotri(fn);
